package requestctx

import (
	"context"
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/library/go/ptr"
)

func TestFeatureFlags(t *testing.T) {
	ctx := context.Background()
	require.Nil(t, GetFeature(ctx, "foo"))

	ctx = WithFeature(ctx, "foo", "bar")
	require.Equal(t, GetFeature(ctx, "foo"), "bar")

	type Boo struct {
		A int
		B *int
	}

	boo := Boo{1, ptr.Int(1543)}

	ctx = WithFeature(ctx, "boo", boo)
	require.Equal(t, GetFeature(ctx, "foo"), "bar")

	booCopy := GetFeature(ctx, "boo").(Boo)

	require.Equal(t, boo.A, booCopy.A)
	require.NotSame(t, boo.B, booCopy.B)
	require.Equal(t, *boo.B, *booCopy.B)

	ctx = WithFeature(ctx, "boo_ptr", &boo)
	require.Equal(t, GetFeature(ctx, "foo"), "bar")

	booPtrCopy := GetFeature(ctx, "boo_ptr").(*Boo)

	require.Equal(t, boo.A, booPtrCopy.A)
	require.NotSame(t, boo.B, booPtrCopy.B)
	require.Equal(t, *boo.B, *booPtrCopy.B)

}
