package requestctx

import (
	"context"

	"a.yandex-team.ru/tasklet/experimental/internal/consts"
)

var requestIDKey struct{}

func WithRequestID(ctx context.Context, requestID consts.RequestID) context.Context {
	return context.WithValue(ctx, &requestIDKey, requestID)
}

func GetRequestID(ctx context.Context) consts.RequestID {
	val := ctx.Value(&requestIDKey)
	if val != nil {
		return val.(consts.RequestID)
	}
	return consts.NilRequestID
}
