package sbresolver

type SandboxResourceQuery struct {
	ResourceID int64             `yaml:"resource_id"`
	Type       string            `yaml:"resource_type"`
	Owner      string            `yaml:"owner"`
	Attributes map[string]string `yaml:"attrs"`
}

type Config struct {
	Enabled       bool `yaml:"enabled"`
	ResolvePeriod int  `yaml:"resolve_period"`

	ArcClient              *SandboxResourceQuery `yaml:"arc_client"`
	SandboxResourceManager *SandboxResourceQuery `yaml:"sb_resource_manager"`
	TaskletExecutor        *SandboxResourceQuery `yaml:"tasklet_executor"`
	TaskletTask            *SandboxResourceQuery `yaml:"tasklet_task"`
}
