package schemaregistry

import (
	"fmt"

	"google.golang.org/grpc/status"

	"a.yandex-team.ru/library/go/valid"
	"a.yandex-team.ru/tasklet/api/v2"
	"a.yandex-team.ru/tasklet/experimental/internal/grpcvalid"
)

func ValidateCreateSchemaRequest(req *taskletv2.CreateSchemaRequest) *status.Status {

	field := grpcvalid.FieldPath("")
	errors := grpcvalid.FieldViolations{}

	if req == nil {
		errors = errors.AddF(field, "required field")
		return grpcvalid.MakeValidationErrorStatus(errors)
	}

	schemaField := field.Join("schema")
	fds := req.GetSchema()
	if fds == nil {
		errors = errors.AddF(schemaField, "required field")
		return grpcvalid.MakeValidationErrorStatus(errors)
	}

	fileField := field.Join("file")
	if len(fds.GetFile()) == 0 {
		errors = errors.AddF(fileField, "required filed")
		return grpcvalid.MakeValidationErrorStatus(errors)

	}

	for idx, fileSchema := range fds.GetFile() {
		field := fileField.Join(fmt.Sprintf("%v", idx))
		errors = errors.AddE(field.Join("package"), valid.StringLen(fileSchema.GetPackage(), 2, 100))
	}

	return grpcvalid.MakeValidationErrorStatus(errors)
}
