package schemaregistry

import (
	"crypto/md5"
	"encoding/hex"

	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/descriptorpb"
)

func calculateFDSHash(d *descriptorpb.FileDescriptorSet) (hash string, err error) {
	marshaller := proto.MarshalOptions{Deterministic: true}
	var bytes []byte
	bytes, err = marshaller.Marshal(d)
	if err != nil {
		return
	}
	h := md5.New()
	_, err = h.Write(bytes)
	if err != nil {
		return
	}
	hash = hex.EncodeToString(h.Sum(nil))
	return
}
