package state

import (
	"sync"

	"a.yandex-team.ru/library/go/core/xerrors"

	"a.yandex-team.ru/tasklet/experimental/internal/consts"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/sandbox"
)

var errNotFound = xerrors.NewSentinel("not found")

// Sandbox resource resolving shared state

type State struct {
	state sync.Map
}

func (s *State) GetResource(resourceType consts.SandboxResourceType) (*sandbox.ResourceInfo, error) {
	val, ok := s.state.Load(resourceType)
	if !ok {
		return nil, errNotFound
	}

	if res, ok := val.(sandbox.ResourceInfo); !ok {
		return nil, xerrors.Errorf("bad resource type %T", val)
	} else {
		return &res, nil
	}
}

func (s *State) SetResource(resource consts.SandboxResourceType, value sandbox.ResourceInfo) {
	s.state.Store(resource, value)
}

var SandboxState = State{}
