package state

import (
	"testing"

	"github.com/stretchr/testify/require"

	"a.yandex-team.ru/tasklet/experimental/internal/consts"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/sandbox"
)

func TestState(t *testing.T) {
	state := State{}

	_, err := state.GetResource(consts.ArcClientResourceType)
	require.ErrorIs(t, err, errNotFound)

	res := sandbox.ResourceInfo{
		ID:        111,
		ProxyLink: "foo",
		MD5:       "bar",
	}
	state.SetResource(consts.ArcClientResourceType, res)

	resp, err := state.GetResource(consts.ArcClientResourceType)
	require.NoError(t, err)
	require.Equal(t, *resp, res)
}
