package common

import (
	"math"

	structpb "github.com/golang/protobuf/ptypes/struct"
	"google.golang.org/protobuf/types/descriptorpb"

	taskletv2 "a.yandex-team.ru/tasklet/api/v2"
)

type ListNamespacesQueryOptions struct {
	Owner string
}

type ListBuildsQueryOptions struct {
	Limit int64
	Token int64
}

func (l *ListBuildsQueryOptions) InferDefaults() {
	if l.Limit == 0 {
		l.Limit = 10
	}

	if l.Token == 0 {
		l.Token = math.MaxInt64
	}
}

// Schema registry types

type SchemaRecord struct {
	Hash        string
	User        string
	Timestamp   int64
	Fds         *descriptorpb.FileDescriptorSet
	Annotations *structpb.Struct
}

type NamespaceUpdateOperation = func(*taskletv2.Namespace) error
type TaskletUpdateOperation = func(*taskletv2.Tasklet) error
