package storage

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/valid"
	"a.yandex-team.ru/tasklet/experimental/internal/storage/memory"
	"a.yandex-team.ru/tasklet/experimental/internal/storage/ydbstore"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/xydb"
)

var (
	_ IStorage = (*ydbstore.Storage)(nil)
	_ IStorage = (*memory.Storage)(nil)
)

var (
	BackendMemory = "memory"
	BackendYdb    = "ydb"
)

type Config struct {
	Backend string       `yaml:"backend" valid:"required"`
	Ydb     *xydb.Config `yaml:"ydb"`
}

func (c *Config) Validate(vctx *valid.ValidationCtx) (bool, error) {
	_ = vctx
	var errors valid.Errors
	switch c.Backend {
	case BackendMemory:
		err := valid.ErrValidation.Wrap(
			xerrors.NewSentinel("memory storage not implemented yet"),
		)
		errors = append(errors, err)

	case BackendYdb:
	default:
		err := valid.ErrValidation.Wrap(
			xerrors.NewSentinel(fmt.Sprintf("Unsupported storage backend: %v", c.Backend)),
		)
		errors = append(errors, err)
	}

	if len(errors) != 0 {
		return true, errors
	}
	return true, nil
}
