package storage

import (
	"context"

	"a.yandex-team.ru/tasklet/api/v2"
	"a.yandex-team.ru/tasklet/experimental/internal/consts"
	"a.yandex-team.ru/tasklet/experimental/internal/storage/common"
)

//go:generate ya tool mockgen -source interfaces.go -package mock -destination ./mock/storage.go
type IStorage interface {
	AddNamespace(ctx context.Context, ns *taskletv2.Namespace) error
	GetNamespaceByName(ctx context.Context, name string) (*taskletv2.Namespace, error)
	GetNamespaceByID(ctx context.Context, id string) (*taskletv2.Namespace, error)
	UpdateNamespace(ctx context.Context, id string, updates ...common.NamespaceUpdateOperation) (
		*taskletv2.Namespace,
		error,
	)
	ListNamespaces(ctx context.Context, owner string) ([]*taskletv2.Namespace, error)

	AddTasklet(ctx context.Context, t *taskletv2.Tasklet) error
	GetTaskletByName(ctx context.Context, name, namespace string) (*taskletv2.Tasklet, error)
	GetTaskletByID(ctx context.Context, id consts.TaskletID) (*taskletv2.Tasklet, error)
	UpdateTasklet(ctx context.Context, t *taskletv2.Tasklet) (*taskletv2.Tasklet, error)
	UpdateTaskletOp(ctx context.Context, id string, updates ...common.TaskletUpdateOperation) (
		*taskletv2.Tasklet,
		error,
	)
	ListTasklets(ctx context.Context, namespace string) ([]*taskletv2.Tasklet, error)

	AddBuild(ctx context.Context, b *taskletv2.Build) error
	GetBuild(ctx context.Context, id string) (*taskletv2.Build, error)
	GetLastBuild(ctx context.Context, taskletID string) (*taskletv2.Build, error)
	ListBuilds(ctx context.Context, taskletID string, options common.ListBuildsQueryOptions) (common.BuildsList, error)

	AddLabel(ctx context.Context, l *taskletv2.Label) error
	GetLabelByName(ctx context.Context, taskletID string, name string) (*taskletv2.Label, error)
	UpdateLabel(ctx context.Context, l *taskletv2.Label) error
	ListLabels(ctx context.Context, taskletID string) ([]*taskletv2.Label, error)

	AddExecution(ctx context.Context, requestID consts.RequestID, e *taskletv2.Execution) (*taskletv2.Execution, error)
	GetExecution(ctx context.Context, id string) (*taskletv2.Execution, error)
	ListExecutionsByTasklet(ctx context.Context, taskletID string, pageToken int64) (common.ExecutionsList, error)
	ListExecutionsByBuild(ctx context.Context, buildID string, pageToken int64) (common.ExecutionsList, error)
	UpdateExecutionStatus(ctx context.Context, id consts.ExecutionID, updates ...common.ExecutionStatusUpdateFunc) (
		*taskletv2.Execution,
		error,
	)
	ArchiveExecution(ctx context.Context, id consts.ExecutionID) error

	ListActiveExecutions(ctx context.Context) ([]*taskletv2.Execution, error)

	// Schema registry methods

	EnsureSchema(ctx context.Context, req common.SchemaRecord) (common.SchemaRecord, error)
	GetSchema(ctx context.Context, hash string) (common.SchemaRecord, error)
}
