package ydbstore

import (
	"context"

	"github.com/ydb-platform/ydb-go-sdk/v3/table"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/xydb"
)

type Storage struct {
	client     *xydb.Client
	l          log.Logger
	LogQueries bool
}

func NewStorage(ydbc *xydb.Client, l log.Logger) *Storage {
	return &Storage{client: ydbc, l: l}
}

func (s *Storage) tableDo(ctx context.Context, op table.Operation, opts ...table.Option) error {
	wr := func(ctx2 context.Context, session table.Session) (err error) {
		ctxlog.Debug(ctx2, s.l, "Query attempt stated")
		defer func() {
			ctxlog.Debugf(ctx2, s.l, "Query attempt finished. Err: %v", err)
		}()
		err = op(ctx2, session)
		return
	}
	return s.client.DB.Table().Do(ctx, wr, opts...)
}

func (s *Storage) tableDoTx(ctx context.Context, op table.TxOperation, opts ...table.Option) error {
	return s.client.DB.Table().DoTx(ctx, op, opts...)
}

func (s *Storage) logQuery(ctx context.Context, name, query string) {
	if !s.LogQueries {
		return
	}
	ctxlog.Infof(ctx, s.l, "Query: %q: %s", name, query)
}
