package testutils

import (
	taskletApi "a.yandex-team.ru/tasklet/api/v2"
	acmodel "a.yandex-team.ru/tasklet/experimental/internal/access/model"
	staffmodel "a.yandex-team.ru/tasklet/experimental/internal/yandex/staff/model"
)

type TestRole struct {
	Role   acmodel.RoleType
	Name   string
	Source taskletApi.PermissionsSubject_ESource
}

const (
	UserBilly = "Billy"
	UserVan   = "Van"
	UserMark  = "Mark"
)

var GroupJym = &staffmodel.GroupInfo{ID: 1, URL: "svc_jym"}
var GroupDungeon = &staffmodel.GroupInfo{ID: 2, URL: "svc_dungeon"}
var GroupSwimmingPool = &staffmodel.GroupInfo{ID: 3, URL: "svc_swimming_pool"}

var GroupIDToURL map[int]*staffmodel.GroupInfo
var GroupURLToID map[string]*staffmodel.GroupInfo

var GroupURLToUser = map[string][]string{
	GroupJym.URL:          {UserBilly, UserVan, UserMark},
	GroupDungeon.URL:      {UserBilly, UserVan},
	GroupSwimmingPool.URL: {},
}

var UserToGroups map[string][]*staffmodel.GroupInfo

var NamespaceRoles = map[string][]*TestRole{
	NamespaceArcadia: {
		&TestRole{
			Role:   acmodel.NamespaceOwner,
			Name:   UserBilly,
			Source: taskletApi.PermissionsSubject_E_SOURCE_USER,
		},
		&TestRole{
			Role:   acmodel.NamespaceOwner,
			Name:   GroupJym.URL,
			Source: taskletApi.PermissionsSubject_E_SOURCE_ABC,
		},
		&TestRole{
			Role:   acmodel.NamespaceRead,
			Name:   GroupDungeon.URL,
			Source: taskletApi.PermissionsSubject_E_SOURCE_ABC,
		},
		&TestRole{
			Role:   acmodel.CreateTasklet,
			Name:   UserVan,
			Source: taskletApi.PermissionsSubject_E_SOURCE_USER,
		},
	},
	NamespaceTaxi: {
		&TestRole{
			Role:   acmodel.NamespaceOwner,
			Name:   GroupSwimmingPool.URL,
			Source: taskletApi.PermissionsSubject_E_SOURCE_ABC,
		},
		&TestRole{
			Role:   acmodel.NamespaceRead,
			Name:   UserBilly,
			Source: taskletApi.PermissionsSubject_E_SOURCE_USER,
		},
	},
}

var TaskletRoles = map[string][]*TestRole{
	TaskletTestTasklet: {
		&TestRole{
			Role:   acmodel.TaskletOwner,
			Name:   UserBilly,
			Source: taskletApi.PermissionsSubject_E_SOURCE_USER,
		},
		&TestRole{
			Role:   acmodel.TaskletWrite,
			Name:   UserMark,
			Source: taskletApi.PermissionsSubject_E_SOURCE_USER,
		},
		&TestRole{
			Role:   acmodel.TaskletRun,
			Name:   GroupSwimmingPool.URL,
			Source: taskletApi.PermissionsSubject_E_SOURCE_ABC,
		},
	},
	TaskletTestTaxiTasklet: {
		&TestRole{
			Role:   acmodel.TaskletOwner,
			Name:   GroupJym.URL,
			Source: taskletApi.PermissionsSubject_E_SOURCE_ABC,
		},
		&TestRole{
			Role:   acmodel.TaskletWrite,
			Name:   UserVan,
			Source: taskletApi.PermissionsSubject_E_SOURCE_USER,
		},
	},
}

func CreatePermissions(permissions **taskletApi.Permissions, roles []*TestRole) {
	for _, role := range roles {
		err := acmodel.AddRole(role.Role, role.Name, role.Source, permissions)
		if err != nil {
			panic(err)
		}
	}
}

func init() {
	UserToGroups = map[string][]*staffmodel.GroupInfo{}
	GroupURLToID = map[string]*staffmodel.GroupInfo{}
	GroupIDToURL = map[int]*staffmodel.GroupInfo{}

	for _, group := range []*staffmodel.GroupInfo{GroupJym, GroupDungeon, GroupSwimmingPool} {
		GroupURLToID[group.URL] = group
		GroupIDToURL[group.ID] = group
	}

	for url, users := range GroupURLToUser {
		for _, user := range users {
			if _, ok := UserToGroups[user]; !ok {
				UserToGroups[user] = []*staffmodel.GroupInfo{}
			}
			UserToGroups[user] = append(UserToGroups[user], GroupURLToID[url])
		}
	}
}
