package testutils

import (
	"fmt"
	"os"
	"strings"
	"sync"
	"testing"
	"unicode"
	"unicode/utf8"

	"a.yandex-team.ru/library/go/test/yatest"
)

// EnsureArcadiaTest is used for skipping medium tests (with recipes) in IDE. Recipe run in IDE is not spported ATM.
func EnsureArcadiaTest(t *testing.T) {
	if !IsYaTest() {
		t.Skip("Skipped due to missing requirements. IDE launch?")
	}
}

func IsYaTest() bool {
	value := os.Getenv("YA_TEST_CONTEXT_FILE")
	return value != ""
}

var testToSeqNo = make(map[string]int)
var testToInfoMtx = sync.Mutex{}

func recodeTestName(t *testing.T) string {
	// NB: fork from testing package
	t.Helper()
	// Drop unusual characters (such as path separators or
	// characters interacting with globs) from the directory name to
	// avoid surprising os.MkdirTemp behavior.
	mapper := func(r rune) rune {
		if r < utf8.RuneSelf {
			const allowed = "!#$%&()+,-.=@^_{}~ "
			if '0' <= r && r <= '9' ||
				'a' <= r && r <= 'z' ||
				'A' <= r && r <= 'Z' {
				return r
			}
			if strings.ContainsRune(allowed, r) {
				return r
			}
		} else if unicode.IsLetter(r) || unicode.IsNumber(r) {
			return r
		}
		return -1
	}
	pattern := strings.Map(mapper, t.Name())
	return pattern
}

func TwistTmpDir(t *testing.T) string {
	t.Helper()
	if IsYaTest() {
		pattern := recodeTestName(t)
		testToInfoMtx.Lock()
		seqNo := testToSeqNo[pattern]
		testToSeqNo[pattern] = seqNo + 1
		testToInfoMtx.Unlock()
		path := yatest.OutputPath(fmt.Sprintf("%s.%03d", pattern, seqNo))
		err := os.Mkdir(path, 0777)
		if err != nil {
			t.Errorf("Failed to create tmpdir: %+v", err)
		}
		return path
	} else {
		return t.TempDir()
	}
}
