package testutils

import (
	"path"
	"path/filepath"
	"strings"

	"a.yandex-team.ru/library/go/core/log"
	logzap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/test/yatest"
)

func MakeLogger(outputFile string) *logzap.Logger {
	conf := logzap.TSKVConfig(log.DebugLevel)
	if IsYaTest() && !path.IsAbs(outputFile) {
		conf.OutputPaths = []string{yatest.OutputPath(outputFile)}
	} else if outputFile != "" {
		conf.OutputPaths = []string{outputFile}
	}
	return logzap.Must(conf)
}

func TwistMakeLogger(tmpdir string, fileName string) *logzap.Logger {
	if !strings.HasSuffix(fileName, ".log") {
		fileName = fileName + ".log"
	}
	zapConf := logzap.ConsoleConfig(log.DebugLevel)
	if IsYaTest() {
		zapConf.OutputPaths = []string{filepath.Join(tmpdir, fileName)}
	} else {
		zapConf.OutputPaths = append(zapConf.OutputPaths, filepath.Join(tmpdir, fileName))
	}
	return logzap.Must(zapConf)
}
