package testutils

import (
	"fmt"
	"net"
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func GetFreePort() (int, error) {
	addr, err := net.ResolveTCPAddr("tcp", "localhost:0")
	if err != nil {
		return 0, err
	}

	l, err := net.ListenTCP("tcp", addr)
	if err != nil {
		return 0, err
	}
	defer func() { _ = l.Close() }()

	p := l.Addr().(*net.TCPAddr).Port

	return p, nil
}

func WaitForPort(timeout time.Duration, port int) error {
	tl := time.NewTimer(timeout)
	defer tl.Stop()

	tick := time.NewTicker(time.Millisecond * 10)
	defer tick.Stop()

	tcpCheck := func() error {
		conn, err := net.Dial("tcp", fmt.Sprintf("localhost:%v", port))
		if err != nil {
			return err
		}
		return conn.Close()
	}

ProbeFor:
	for {
		select {
		case <-tl.C:
			return xerrors.Errorf("tcp check on port %v timeout", port)
		case <-tick.C:
			if tcpCheck() == nil {
				break ProbeFor
			}
		}
	}
	return nil
}
