package utils

import (
	"os"
	"strings"

	"github.com/mitchellh/go-homedir"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func LoadToken(tokenPath string) (string, error) {
	if len(tokenPath) == 0 {
		return "", xerrors.New("Token path is empty")
	}

	if buf, err := homedir.Expand(tokenPath); err == nil {
		tokenPath = buf
	}

	if tokenData, err := os.ReadFile(tokenPath); err == nil {
		return strings.TrimSpace(string(tokenData)), nil
	} else {
		return "", err
	}
}

func MustToken(s string, err error) string {
	if err != nil {
		panic(err)
	}
	return s
}
