package abc

import (
	"encoding/json"
	"testing"

	"github.com/stretchr/testify/require"

	testData "a.yandex-team.ru/tasklet/experimental/internal/yandex/abc/gotest/data"
)

type memberTestData struct {
	name    string
	roleCnt int
}

type serviceTestData struct {
	service *Service
	members []memberTestData
}

func TestExtractedServices(t *testing.T) {
	membersData, err := testData.Get("members.json")
	require.NoError(t, err)

	abcResponse := &servicesMembersListResponse{}
	err = json.Unmarshal(membersData, abcResponse)
	require.NoError(t, err)

	services := ServicesBySlugs{}
	buildServicesFromMembers(abcResponse.Results, services)

	sandboxService, ok := services["sandbox"]
	require.True(t, ok)
	taskletsService, ok := services["tasklets"]
	require.True(t, ok)

	for _, tt := range []serviceTestData{
		{service: sandboxService, members: []memberTestData{{"r-vetrov", 10}}},
		{service: taskletsService, members: []memberTestData{{"r-vetrov", 7}, {"alximik", 5}}},
	} {
		for _, member := range tt.members {
			extractedMember, ok := tt.service.Members[member.name]
			require.Truef(t, ok, "there is no %v in %v", member.name, tt.service.Slug)
			require.Equalf(
				t, member.roleCnt, len(extractedMember.Roles),
				"wrong role count for %v in %v", member.name, tt.service.Slug,
			)
		}
		require.Equalf(t, len(tt.service.Members), len(tt.members), "Service = %v", tt.service.Slug)
	}
}
