package abc

const (
	serviceMembersListRequestFields = "service,role.id,role.code,role.scope.slug,person.login,person.is_robot"
)

type responseWithPagination struct {
	Next     string `json:"next"`
	Previous string `json:"previous"`
}

type serviceMemberResponse struct {
	Person struct {
		Login   string `json:"login"`
		IsRobot bool   `json:"is_robot"`
	} `json:"person"`
	Service struct {
		ID       int64  `json:"id"`
		Slug     string `json:"slug"`
		ParentID int64  `json:"parent"`
	} `json:"service"`
	Role struct {
		ID    int64 `json:"id"`
		Scope struct {
			Slug string `json:"slug"`
		} `json:"scope"`
		Code string `json:"code"`
	} `json:"role"`
}

type servicesMembersListResponse struct {
	responseWithPagination

	Results []serviceMemberResponse `json:"results"`
}
