package auth

import (
	"context"

	"github.com/go-resty/resty/v2"
)

// ServicePolicyFactory provides one-factor auth: oauth token or tvm service ticket
type ServicePolicyFactory interface {
	NewAuthPolicy(ctx context.Context) (Policy, error)
}

// UserPolicyFactory provides two-factor auth: tvm service + user tickets
type UserPolicyFactory interface {
	NewAuthPolicy(ctx context.Context, userTicket string) (Policy, error)
}

type Policy interface {
	Apply(req *resty.Request) error
}
