package auth

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
	tvmmw "a.yandex-team.ru/library/go/httputil/middleware/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

var (
	_ ServicePolicyFactory = (*TVMServicePolicyFactory)(nil)
)

type TVMServicePolicyFactory struct {
	TVMDstID tvm.ClientID
	TVM      tvm.Client
}

func (f TVMServicePolicyFactory) NewAuthPolicy(ctx context.Context) (Policy, error) {
	tvmServiceTicket, err := f.TVM.GetServiceTicketForID(ctx, f.TVMDstID)
	if err != nil {
		return TVMServiceAuthPolicy{}, xerrors.Errorf("failed get TVM service ticket for datasync request: %w", err)
	}
	return TVMServiceAuthPolicy{
		serviceTicket: tvmServiceTicket,
	}, nil
}

type TVMServiceAuthPolicy struct {
	serviceTicket string
}

func (ap TVMServiceAuthPolicy) Apply(request *resty.Request) error {
	request.SetHeader(tvmmw.XYaServiceTicket, ap.serviceTicket)
	return nil
}
