package app

import (
	"context"
	"net/http"

	"a.yandex-team.ru/library/go/core/xerrors"
	tvmmiddleware "a.yandex-team.ru/library/go/httputil/middleware/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type AuthorizationInterface interface {
	AuthorizeHandler() func(next http.Handler) http.Handler
}

type Authorization struct {
	IdmTVM    tvm.ClientID
	TvmClient tvm.Client
}

func (auth *Authorization) AuthClient(_ context.Context, clientID tvm.ClientID) error {
	if clientID != auth.IdmTVM {
		return xerrors.Errorf("Allow only for IDM TVM service. Source ticket ID: %v", clientID)
	}
	return nil
}

func (auth *Authorization) AuthorizeHandler() func(next http.Handler) http.Handler {
	return tvmmiddleware.CheckServiceTicket(auth.TvmClient, tvmmiddleware.WithClientAuth(auth.AuthClient))
}
