package app

import (
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/idm/idmclient"
)

type Response interface{}

type BaseResponse struct {
	Code int `json:"code"`

	Warning string `json:"warning,omitempty"`
	Error   string `json:"error,omitempty"`
	Fatal   string `json:"fatal,omitempty"`
}

type InfoResponse struct {
	BaseResponse
	Roles *idmclient.RoleTreeNode `json:"roles"`
}

type RolesResponse struct {
	BaseResponse
	NextURL string            `json:"next-url,omitempty"`
	Roles   []*idmclient.Role `json:"roles,omitempty"`
}
