package lib

import (
	"fmt"
	"strings"

	taskletv2 "a.yandex-team.ru/tasklet/api/v2"
)

type NodeType int

const (
	NamespaceRoleNode NodeType = iota
	TaskletRoleNode
	OtherNode
)

type RoleNode struct {
	Type          NodeType
	NamespaceName string
	TaskletName   string
	Role          string
	Slug          string
	SlugPath      string
	ValuePath     string
}

func NewRoleNode(slugPath string) *RoleNode {
	values, slug := ValueAndSlugFromSlugPath(slugPath)
	roleNode := &RoleNode{SlugPath: slugPath, Slug: slug, ValuePath: values}
	valuesArray := strings.Split(values, "/")
	valuesArray = valuesArray[1 : len(valuesArray)-1]

	if len(valuesArray) == 0 {
		roleNode.Type = OtherNode
		return roleNode
	}

	roleNode.NamespaceName, valuesArray = valuesArray[0], valuesArray[1:]
	if len(valuesArray) == 0 {
		roleNode.Type = OtherNode
		return roleNode
	}

	objType, valuesArray := valuesArray[0], valuesArray[1:]
	if len(valuesArray) == 0 {
		roleNode.Type = OtherNode
		return roleNode
	}

	switch objType {
	case "roles":
		roleNode.Type = NamespaceRoleNode
		roleNode.Role = valuesArray[0]
		return roleNode
	case "tasklet":
		roleNode.TaskletName, valuesArray = valuesArray[0], valuesArray[1:]
		if len(valuesArray) == 0 {
			roleNode.Type = OtherNode
			return roleNode
		}
		roleNode.Type = TaskletRoleNode
		roleNode.Role = valuesArray[0]
		return roleNode
	default:
		roleNode.Type = OtherNode
		return roleNode
	}
}

func NamespaceRoleSlugParent(namespace *taskletv2.Namespace) string {
	return fmt.Sprintf("/namespace/%s/type/roles/role/", namespace.Meta.Name)
}

func NamespaceRoleSlug(namespace *taskletv2.Namespace, role string) string {
	return NamespaceRoleSlugParent(namespace) + role + "/"
}

func TaskletRoleParent(tasklet *taskletv2.Tasklet) string {
	return fmt.Sprintf(
		"/namespace/%s/type/tasklet/name/%s/role/",
		tasklet.Meta.Namespace,
		tasklet.Meta.Name,
	)
}

func TaskletRoleSlug(tasklet *taskletv2.Tasklet, role string) string {
	return TaskletRoleParent(tasklet) + role + "/"
}

func ValueAndSlugFromSlugPath(slugPath string) (string, string) {
	slugPathArray := strings.Split(slugPath, "/")
	slugPathArray = append(slugPathArray, "")
	var valuePathArray []string
	for i := 0; i < len(slugPathArray); i += 2 {
		valuePathArray = append(valuePathArray, slugPathArray[i])
	}
	return strings.Join(valuePathArray, "/"), slugPathArray[len(slugPathArray)-3]
}
