package lib

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestRoleCreator(t *testing.T) {
	namespaceSlugs := []string{"", "namespace", "arcadia", "type", "roles", "role"}
	namespaceRoleSlug := "CreateTasklet"
	taskletSlugs := []string{"", "namespace", "arcadia", "type", "tasklet", "name", "new_tasklet", "role"}
	taskletRoleSlug := "TaskletOwner"

	slugPath := ""
	for _, v := range namespaceSlugs {
		slugPath += v + "/"
		roleNode := NewRoleNode(slugPath)
		assert.Equal(t, slugPath, roleNode.SlugPath)
		assert.Equal(t, v, roleNode.Slug)
		assert.Equal(t, OtherNode, roleNode.Type)
	}
	slugPath += namespaceRoleSlug + "/"
	roleNode := NewRoleNode(slugPath)
	assert.Equal(t, slugPath, roleNode.SlugPath)
	assert.Equal(t, namespaceRoleSlug, roleNode.Slug)
	assert.Equal(t, NamespaceRoleNode, roleNode.Type)

	slugPath = ""
	for _, v := range taskletSlugs {
		slugPath += v + "/"
		roleNode := NewRoleNode(slugPath)
		assert.Equal(t, slugPath, roleNode.SlugPath)
		assert.Equal(t, v, roleNode.Slug)
		assert.Equal(t, OtherNode, roleNode.Type)
	}
	slugPath += taskletRoleSlug + "/"
	roleNode = NewRoleNode(slugPath)
	assert.Equal(t, slugPath, roleNode.SlugPath)
	assert.Equal(t, taskletRoleSlug, roleNode.Slug)
	assert.Equal(t, TaskletRoleNode, roleNode.Type)
}
