package services

import (
	"context"
	"testing"

	"a.yandex-team.ru/library/go/test/canon"
	idmtestutils "a.yandex-team.ru/tasklet/experimental/internal/yandex/idm/testutils"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/staff"
	stafftestutls "a.yandex-team.ru/tasklet/experimental/internal/yandex/staff/testutils"
	"github.com/stretchr/testify/suite"
)

type RolesSuite struct {
	idmtestutils.BaseSuite
}

func (es *RolesSuite) TestRolesCanon() {
	ctx := context.Background()
	es.BootstrapContext(ctx)
	rb := RoleBuilder{
		Logger: es.Logger,
		DB:     es.TestStorage,
	}
	staffGroupsCache := staff.NewStaffGroupsCache(
		&stafftestutls.StaffClientMock{Logger: es.Logger},
	)
	defer staffGroupsCache.Stop()
	roles, err := rb.IdmRolesList(
		ctx, staffGroupsCache,
	)
	es.NoError(err)
	canon.SaveJSON(es.T(), roles)
}

func TestRoles(t *testing.T) {
	s := &RolesSuite{}
	suite.Run(t, s)
}
