# -*- coding: utf-8 -*-
# This code is prepended to both workflow files.

try:
    from .mock import AccessDenied, any_from, groupify
    ignore_approvers = False
    fields_data = {"path": "//foo/bar"}
except ImportError:
    pass


ROLE_NAMESPACE_READ = "NamespaceRead"
ROLE_NAMESPACE_CREATE_TASKLET = "CreateTasklet"
ROLE_NAMESPACE_OWNER = "NamespaceOwner"

ROLE_TASKLET_READ = "TaskletRead"
ROLE_TASKLET_WRITE = "TaskletWrite"
ROLE_TASKLET_RUN = "TaskletRun"
ROLE_TASKLET_OWNER = "TaskletOwner"

NAMESPACE_ROLES = [ROLE_NAMESPACE_READ, ROLE_NAMESPACE_CREATE_TASKLET, ROLE_NAMESPACE_OWNER]
TASKLET_ROLES = [ROLE_TASKLET_READ, ROLE_TASKLET_WRITE, ROLE_TASKLET_RUN, ROLE_TASKLET_OWNER]

ALL_ROLES = NAMESPACE_ROLES + TASKLET_ROLES

TESTING_SYSTEM_SLUG = "taskletstest"
PRODUCTION_SYSTEM_SLUG = "tasklets"

TESTING_TVM_APP = "2031963"
PRODUCTION_TVM_APP = "2033141"

SYSTEM_TVM_MAP = {
    TESTING_SYSTEM_SLUG: TESTING_TVM_APP,
    PRODUCTION_SYSTEM_SLUG: PRODUCTION_TVM_APP
}

SYSTEM_GROUP = 249436  # Tasklets
SYSTEM_ROBOT = "robot-tasklets"


def validate_user(user):
    if user.is_tvm_app:
        raise AccessDenied(u"TVM applications are not allowed")

    return True


def validate_group(group):
    if group.type != "service":
        raise AccessDenied(u"Неподерживаемый тип группы {}.".format(group.type))

    return True


def run_workflow(requester=None, user=None, group=None, role_info=None, system=None):
    role = role_info["role"]
    if user is not None:
        validate_user(user)
    else:
        validate_group(group)

    warnings = []
    override_review_days = None
    workflow_comment = None

    if requester is not None:
        if requester.is_tvm_app and requester.username == SYSTEM_TVM_MAP[system.slug]:
            return [], ["Role requested by admin system {} without responsibles".format(requester.username)], [], None, None
        if requester.username == SYSTEM_ROBOT:
            return [], ["Role requested by admin robot {} without responsibles".format(requester.username)], [], None, None
        if groupify(SYSTEM_GROUP) in requester.groups:
            return [], ["Role requested by admin group {} without responsibles".format(groupify(SYSTEM_GROUP).slug)], [], None, None

    if role in NAMESPACE_ROLES:
        responsible_role = role_info.copy()
        responsible_role["role"] = ROLE_NAMESPACE_OWNER
        users = system.all_users_with_role(
            responsible_role,
        )
        if not users:
            raise AccessDenied(u"Namespace hasn't owners. Please, contact administrator")
        responsible = [any_from(users)]
        return responsible, warnings, [], override_review_days, workflow_comment

    if role in TASKLET_ROLES:
        responsible_role = role_info.copy()
        responsible_role["role"] = ROLE_TASKLET_OWNER
        users = system.all_users_with_role(
            responsible_role,
        )
        if not users:
            raise AccessDenied(u"Tasklet hasn't owners. Please, contact administrator")
        responsible = [any_from(users)]
        return responsible, warnings, [], override_review_days, workflow_comment
    raise AccessDenied(u"Role request not allowed")
