from workflow import common
from workflow import mock


EXISTING_ROLES = {
    (common.ROLE_NAMESPACE_READ, "arcadia"): [mock.USER_ALICE],
    (common.ROLE_NAMESPACE_OWNER, "arcadia"): [mock.KEK_GROUP, mock.USER_CHARLY],
    (common.ROLE_TASKLET_OWNER, "test_tasklet"): [mock.USER_BOB, mock.USER_CHARLY]
}


class System(object):
    def __init__(self):
        self.slug = "tasklets"

    def __get_memebers(self, role):
        members = []
        if role["role"] in common.NAMESPACE_ROLES:
            for item in EXISTING_ROLES.get((role["role"], role["namespace"]), []):
                if isinstance(item, mock.User):
                    members.append(item)
                else:
                    members.extend(item.members)
        if role["role"] in common.TASKLET_ROLES:
            for item in EXISTING_ROLES.get((role["role"], role["name"]), []):
                if isinstance(item, mock.User):
                    members.append(item)
                else:
                    members.extend(item.members)
        return members

    def all_users_with_role(self, role):
        return self.__get_memebers(role)


def test__admin_workflow_requests():
    for requester in (mock.ROBOT_TASKLETS, mock.USER_PARTOS, mock.User(common.PRODUCTION_TVM_APP, is_tvm_app=True)):
        for role in [
            {"role": common.ROLE_NAMESPACE_READ, "namespace": "arcadia"},
            {"role": common.ROLE_TASKLET_READ, "name": "test_tasklet"}
        ]:
            approvers, _, _, _, _ = common.run_workflow(
                requester=requester,
                user=mock.USER_HERMES,
                role_info=role,
                system=System()
            )
            assert approvers == [], "Requester: {}, User: {}, Role: {}, approvers: {}".format(
                requester, mock.USER_HERMES, role, approvers
            )
            approvers, _, _, _, _ = common.run_workflow(
                requester=requester,
                group=mock.KEK_GROUP,
                role_info=role,
                system=System()
            )
            assert approvers == [], "Requester: {}, Group: {}, Role: {}, approvers: {}".format(
                requester, mock.KEK_GROUP, role, approvers
            )


def test__user_workflow():
    approvers, _, _, _, _ = common.run_workflow(
        requester=mock.USER_HERMES,
        user=mock.USER_HERMES,
        role_info={"role": common.ROLE_NAMESPACE_READ, "namespace": "arcadia"},
        system=System())

    assert len(approvers) == 1
    assert len(approvers[0].approvers) == 3
    for user in mock.KEK_GROUP.members + [mock.USER_CHARLY]:
        assert user in approvers[0].approvers, "{} not in approvers {}".format(user.username, approvers[0].approvers)

    approvers, _, _, _, _ = common.run_workflow(
        requester=mock.USER_HERMES,
        user=mock.USER_HERMES,
        role_info={"role": common.ROLE_TASKLET_READ, "name": "test_tasklet"},
        system=System())

    assert len(approvers) == 1
    assert len(approvers[0].approvers) == 2
    for user in [mock.USER_BOB, mock.USER_CHARLY]:
        assert user in approvers[0].approvers, "{} not in approvers {}".format(user.username, approvers[0].approvers)


def test__group_workflow():
    approvers, _, _, _, _ = common.run_workflow(
        requester=mock.USER_HERMES,
        group=mock.TASKLET_GROUP,
        role_info={"role": common.ROLE_NAMESPACE_READ, "namespace": "arcadia"},
        system=System())

    assert len(approvers) == 1
    assert len(approvers[0].approvers) == 3
    for user in mock.KEK_GROUP.members + [mock.USER_CHARLY]:
        assert user in approvers[0].approvers, "{} not in approvers {}".format(user.username, approvers[0].approvers)

    approvers, _, _, _, _ = common.run_workflow(
        requester=mock.USER_HERMES,
        group=mock.KEK_GROUP,
        role_info={"role": common.ROLE_TASKLET_READ, "name": "test_tasklet"},
        system=System())

    assert len(approvers) == 1
    assert len(approvers[0].approvers) == 2
    for user in [mock.USER_BOB, mock.USER_CHARLY]:
        assert user in approvers[0].approvers, "{} not in approvers {}".format(user.username, approvers[0].approvers)
