package sandbox

import (
	"os"
	"strings"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/xerrors"
)

type Config struct {
	Host           string `yaml:"host" valid:"required"`
	TokenPath      string `yaml:"token_path"`
	TransportDebug bool   `yaml:"transport_debug"`
}

var ErrTokenLoadFailure = xerrors.NewSentinel("token not found")

const (
	sandboxSessionEnvVar    = "SANDBOX_SESSION"
	ytExternalSessionEnvVar = "YT_SECURE_VAULT_TASKLET_SESSION"
)

func GetSandboxSessionFromEnv(logger log.Logger) (string, error) {
	if token := os.Getenv(sandboxSessionEnvVar); token != "" {
		logger.Debugf("Using Sandbox session from environmental variable %v", sandboxSessionEnvVar)
		return strings.TrimSpace(token), nil
	}
	return "", ErrTokenLoadFailure
}

func YTGetExternalSessionFromEnv(logger log.Logger) (string, error) {
	if token := os.Getenv(ytExternalSessionEnvVar); token != "" {
		logger.Debugf("Using external session from environmental variable %v", sandboxSessionEnvVar)
		return strings.TrimSpace(token), nil
	}
	return "", ErrTokenLoadFailure
}
