package corpus

import (
	"embed"
)

//go:embed *.json
var embeddedFS embed.FS

func Get(name string) ([]byte, error) {
	return embeddedFS.ReadFile(name)
}

func MustGet(name string) []byte {
	bytes, err := Get(name)
	if err != nil {
		panic(err)
	}
	return bytes
}
