package sandbox

import (
	"time"

	"a.yandex-team.ru/tasklet/experimental/internal/consts"
)

const taskletServiceTesting = "tasklets_testing"
const taskletServiceProduction = "tasklets_production"

type SecretDataRequest struct {
	ID      string
	Version string
}

type SecretKeyValue struct {
	Value    string
	Encoding string
}

//goland:noinspection GoNameStartsWithPackageName
type SandboxTaskID int64

func (s SandboxTaskID) ToInt() int64 {
	return int64(s)
}

//goland:noinspection GoNameStartsWithPackageName
type SandboxSession string

func (s SandboxSession) String() string {
	return string(s)
}

//goland:noinspection GoNameStartsWithPackageName
type SandboxExternalSession string

func (s SandboxExternalSession) String() string {
	return string(s)
}

type ExternalSessionInfo struct {
	Token       SandboxExternalSession `json:"-"`
	TaskID      SandboxTaskID
	ExecutionID consts.ExecutionID
}

type SessionInfo struct {
	Token  SandboxSession `json:"-"`
	Login  string
	TaskID SandboxTaskID
}

type UserGroup struct {
	Name      string
	CacheTime time.Time
	Members   []string
}
