package sd

import (
	"os"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func MustGetOwnHostname() string {
	if hostname, err := GetOwnHostname(); err != nil {
		panic(err)
	} else {
		return hostname
	}
}

func GetOwnHostname() (string, error) {
	if hostname := os.Getenv("DEPLOY_POD_PERSISTENT_FQDN"); hostname != "" {
		return hostname, nil
	}

	if hostname := os.Getenv("HOSTNAME"); hostname != "" {
		return hostname, nil
	}

	if hostname, err := os.Hostname(); err != nil {
		return "", err
	} else if hostname != "" {
		return hostname, nil
	}

	return "", xerrors.New("couldn't determine hostname")
}
