package testutils

import (
	"context"
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
	testutils "a.yandex-team.ru/tasklet/experimental/internal/test_utils"
	"a.yandex-team.ru/tasklet/experimental/internal/yandex/idm/lib"
	staffmodel "a.yandex-team.ru/tasklet/experimental/internal/yandex/staff/model"
)

type StaffClientMock struct {
	Logger log.Logger
}

func (c *StaffClientMock) ListGroupsByIDs(ctx context.Context, ids []int) ([]*staffmodel.GroupInfo, error) {
	ctxlog.Infof(ctx, c.Logger, "Call ListGroupsByIDs method with ids: %v", ids)
	var result []*staffmodel.GroupInfo
	for _, id := range ids {
		if v, ok := testutils.GroupIDToURL[id]; ok {
			result = append(result, v)
		}
	}
	ctxlog.Infof(ctx, c.Logger, "Call result for ListGroupsByIDs method: %v", result)
	return result, nil
}

func (c *StaffClientMock) ListGroupsByNames(ctx context.Context, names []string) ([]*staffmodel.GroupInfo, error) {
	ctxlog.Infof(ctx, c.Logger, "Call ListGroupsByNames method with names: %v", names)
	var result []*staffmodel.GroupInfo
	for _, name := range names {
		if v, ok := testutils.GroupURLToID[name]; ok {
			result = append(result, v)
		}
	}
	ctxlog.Infof(ctx, c.Logger, "Call result for ListGroupsByNames method: %v", result)
	return result, nil
}

func (c *StaffClientMock) GroupByID(ctx context.Context, id int) (*staffmodel.GroupInfo, error) {
	ctxlog.Infof(ctx, c.Logger, "Call GroupByID method with id: %v", id)
	if v, ok := testutils.GroupIDToURL[id]; ok {
		return v, nil
	} else {
		return nil, &lib.HTTPError{ErrorCode: "404", Msg: fmt.Sprintf("Group '%v' not found", id)}
	}
}

func (c *StaffClientMock) GroupByName(ctx context.Context, name string) (*staffmodel.GroupInfo, error) {
	ctxlog.Infof(ctx, c.Logger, "Call GroupByName method with name: %v", name)
	if v, ok := testutils.GroupURLToID[name]; ok {
		return v, nil
	} else {
		return nil, &lib.HTTPError{ErrorCode: "404", Msg: fmt.Sprintf("Group '%v' not found", name)}
	}
}

func (c *StaffClientMock) ListUserGroups(ctx context.Context, login string) (map[string]bool, error) {
	ctxlog.Infof(ctx, c.Logger, "Call ListUserGroups method with login: %v", login)
	result := map[string]bool{}
	if groups, ok := testutils.UserToGroups[login]; ok {
		for _, g := range groups {
			result[g.URL] = true
		}
	}
	return result, nil
}
