package xydb

import (
	"context"

	"github.com/ydb-platform/ydb-go-sdk/v3/table/result"

	"a.yandex-team.ru/library/go/core/xerrors"
)

// EnsureOneRowCursor set YDB result.Result cursor to first row and ensures that it exactly one
func EnsureOneRowCursor(ctx context.Context, ydbRes result.Result) error {
	ydbRes.NextResultSet(ctx)

	if ydbRes.Err() != nil {
		return xerrors.Errorf("failed to get first result set: %w", ydbRes.Err())
	}

	if !ydbRes.HasNextRow() {
		return xerrors.Errorf("failed to get first row - empty result: %w", ErrNoRows)
	}

	ydbRes.NextRow()

	if ydbRes.HasNextRow() {
		return xerrors.Errorf(
			"result contains more than one row (%d): %w",
			ydbRes.CurrentResultSet().RowCount(),
			ErrMoreThenOneRow,
		)
	}

	return nil
}
