package ytdriver

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/valid"
	"a.yandex-team.ru/yt/go/ypath"
)

var _ valid.Validator = (*Config)(nil)

type Config struct {
	Enabled       bool   `yaml:"enabled"`
	Cluster       string `yaml:"cluster" valid:"required"`
	TokenPath     string `yaml:"token_path" valid:"required"`
	ResourceCache string `yaml:"resource_cache" valid:"required"`
}

func (c *Config) Validate(vctx *valid.ValidationCtx) (bool, error) {
	_ = vctx
	if !c.Enabled {
		return true, nil
	}
	var verrs valid.Errors
	if richPath, err := ypath.Parse(c.ResourceCache); err != nil {
		verrs = append(
			verrs,
			valid.ErrValidation.Wrap(xerrors.Errorf("Malformed \"ResourceCache\": %v", err)),
		)
	} else if richPath.Path.String() != c.ResourceCache {
		verrs = append(
			verrs,
			valid.ErrValidation.Wrap(xerrors.New("Failed to parse \"ResourceCache\"")),
		)
	}
	if len(verrs) != 0 {
		return true, verrs
	}
	return true, nil

}
