package corpus

import (
	"embed"
	"strings"

	operationSpec "a.yandex-team.ru/yt/go/mapreduce/spec"
	"a.yandex-team.ru/yt/go/yson"
)

const (
	fileSuffix = ".yson"
)

//go:embed *.yson
var embeddedFS embed.FS

func Get(name string) (*operationSpec.Spec, error) {
	fullName := name + fileSuffix
	if bytes, err := embeddedFS.ReadFile(fullName); err == nil {
		spec := &operationSpec.Spec{}
		err := yson.Unmarshal(bytes, spec)
		if err != nil {
			return nil, err
		} else {
			return spec, nil
		}
	} else {
		return nil, err
	}
}

func List() []string {
	var embedded []string
	items, _ := embeddedFS.ReadDir(".")
	for _, item := range items {
		if !item.IsDir() && strings.HasSuffix(item.Name(), fileSuffix) {
			name := item.Name()[0 : len(item.Name())-len(fileSuffix)]
			embedded = append(embedded, name)
		}
	}
	return embedded
}
