package main

import (
	"fmt"
	"os"
	"path"
	"strings"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	logZap "a.yandex-team.ru/library/go/core/log/zap"
)

func setupLogger(outDir string) *logZap.Logger {
	conf := logZap.ConsoleConfig(log.DebugLevel)
	conf.OutputPaths = append(conf.OutputPaths, path.Join(outDir, "mock.log"))
	logger := logZap.Must(conf)
	return logger
}

const EnvTargetFolder = "TASKLET_TESTS_PATH"

func main() {
	workDir, ok := os.LookupEnv(EnvTargetFolder)
	if !ok {
		panic(fmt.Sprintf("No target folder at env %s", EnvTargetFolder))
	}
	l := setupLogger(workDir)
	l.Infof("Starting ...")
	for _, item := range os.Environ() {
		l.Infof("ENV: %s", item)
	}

	ticker := time.NewTicker(10 * time.Millisecond)
	defer ticker.Stop()
	timeout := time.After(1 * time.Minute)

	command := ""
	commandFile := path.Join(workDir, "done")
MainLoop:
	for {
		select {
		case <-ticker.C:
			_, err := os.Stat(commandFile)
			if os.IsNotExist(err) {
				continue MainLoop
			}
			l.Infof("Exit flag appeared. Exiting")
			bytes, err := os.ReadFile(commandFile)
			if err != nil {
				panic(err)
			}
			command = strings.TrimSpace(string(bytes))
			l.Infof("Got command: %q", command)
			break MainLoop
		case <-timeout:
			l.Error("Timeout hit! Crashing")
			panic("timeout")
		}
	}

	switch command {
	case "done":
		os.Exit(0)
	case "crash":
		os.Exit(1)
	default:
		panic(command)
	}
}
