package ydbmigrate

import (
	"context"
	"time"

	"github.com/gofrs/uuid"
	"github.com/ydb-platform/ydb-go-sdk/v3/table/types"

	"a.yandex-team.ru/tasklet/experimental/internal/yandex/xydb"
)

type DBVersionInfo struct {
	Version       SchemaVersion
	Description   string
	MigrationTime time.Time
}

var InitialDBVersionInfo = DBVersionInfo{
	Version:       NilSchemaVersion,
	Description:   "none",
	MigrationTime: time.Time{},
}

type MigrationLease uuid.UUID

var NilMigrationLease = MigrationLease(uuid.Nil)

func NewMigrationLease() MigrationLease {
	return MigrationLease(uuid.Must(uuid.NewV4()))
}

func (l *MigrationLease) UnmarshalYDB(v types.RawValue) error {
	if v.IsNull() {
		*l = NilMigrationLease
		return nil
	}

	buf, err := uuid.FromString(string(v.String()))
	if err != nil {
		return err
	}
	*l = MigrationLease(buf)
	return nil
}

func (l *MigrationLease) String() string {
	return (*uuid.UUID)(l).String()
}

type Mutation struct {
	MutationName string
	Func         func(context.Context, *xydb.Client) error
}

type Migration struct {
	BaseVersion SchemaVersion
	Description string
	Mutations   []Mutation
}

func (m Migration) GetTargetVersion() SchemaVersion {
	return m.BaseVersion + 1
}
