from __future__ import print_function

from argparse import ArgumentParser
from pathlib import Path

from tasklet.experimental.registry_test.app.lib.protobuf_support import ProtoSupport


class App:
    STRING_CONTAINER_ID = "tasklet.experimental.registry_test.primitive_containers.StringContainer"
    ENUM_CONTAINER_ID = "tasklet.experimental.registry_test.primitive_containers.SimpleEnumContainer"
    BASE_MESSAGE_ID = "tasklet.experimental.registry_test.extended_messages.BaseMessage"

    @staticmethod
    def parse_path(path: str) -> Path:
        return Path(path).resolve().expanduser().absolute()

    def __init__(self):
        parser = ArgumentParser()
        parser.add_argument("--fds", type=App.parse_path, required=True)

        self._parser = parser

    def run(self):
        args = self._parser.parse_args()
        self.ps = ProtoSupport(args.fds)
