#!/bin/sh -x

# NB: using grpcurl: https://github.com/fullstorydev/grpcurl
# Fast install:
#   * go install github.com/fullstorydev/grpcurl/cmd/grpcurl@latest
#   * docker run fullstorydev/grpcurl api.grpc.me:443 list
#   * ya make ~/arc/vendor/github.com/fullstorydev/grpcurl/cmd/grpcurl/

bnry="grpccurl"

if [ -x "$(which grpccurl)" ]; then
    bnry=$(which grpccurl)
elif [ -x "$(which ~/go/bin/grpcurl)" ]; then
    bnry=$(which ~/go/bin/grpcurl)
else
    bnry="docker run --network=host fullstorydev/grpcurl"
fi

grpc="${bnry} -plaintext localhost:6666 "
echo "using grpc: ${grpc}"

echo "List services:"

$grpc list

$grpc describe tasklet.api.v2.TaskletService.CreateTasklet
$grpc describe tasklet.api.v2.TaskletMeta

#
# Create Namespace
#

grpc="${bnry} -v -format json -d @ -plaintext localhost:6666 "

$grpc tasklet.api.v2.TaskletService/CreateNamespace <<EOF
{
    "namespace": {
        "meta": {
            "name": "woody",
            "account_id": "abc:57"
        }
    }
}
EOF

$grpc tasklet.api.v2.TaskletService/GetNamespace <<EOF
{
    "namespace": "woody"
}
EOF

$grpc tasklet.api.v2.TaskletService/GetNamespace <<EOF
{
    "namespace": "billy_eilish"
}
EOF

$grpc tasklet.api.v2.TaskletService/ListNamespaces <<EOF
{
    "owner": "abc:57"
}
EOF

#
# Add Tasklet
#

$grpc tasklet.api.v2.TaskletService/CreateTasklet <<EOF
{
    "tasklet": {
        "meta": {
            "name": "json_to_yaml",
            "namespace": "woody",
            "account_id": "abc:57"
        },
        "spec": {
            "catalog": "/library/core"
        }
    }
}
EOF

$grpc tasklet.api.v2.TaskletService/GetTasklet <<EOF
{
    "name": "json_to_yaml",
    "namespace": "woody"
}
EOF

$grpc tasklet.api.v2.TaskletService/ListTasklets <<EOF
{
    "namespace": "woody"
}
EOF

#
# Add build
#
builds="$(
    $grpc tasklet.api.v2.TaskletService/ListBuilds <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "woody"
}
EOF
)"

last_build="$(echo "${builds}" | grep '"id":' | awk ' { print $NF; }' | tr -d '",' | head -n 1)"

echo "Last build = ${last_build}"
if [ x"${last_build}" = x"" ]; then
    for rev in 0 1 2 3 4 5; do
        $grpc tasklet.api.v2.TaskletService/CreateBuild <<EOF
    {
        "build": {
            "meta": {
                "tasklet": "json_to_yaml",
                "namespace": "woody"
            },
            "spec": {
                "description": "build for json_to_yaml; rev: ${rev}"
            }
        }
    }
EOF
    done
fi
builds="$(
    $grpc tasklet.api.v2.TaskletService/ListBuilds <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "woody"
}
EOF
)"

last_build="$(echo "${builds}" | grep '"id":' | awk ' { print $NF; }' | tr -d '",' | head -n 1)"

echo "Last build = ${last_build}"

$grpc tasklet.api.v2.TaskletService/ListBuilds <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "woody"
}
EOF

$grpc tasklet.api.v2.TaskletService/GetBuild <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "woody",
    "build_id": "${last_build}"
}
EOF

# Bad reqs
$grpc tasklet.api.v2.TaskletService/GetBuild <<EOF
{
    "tasklet": "json_to_yaml_invalid",
    "namespace": "woody",
    "build_id": "${last_build}"
}
EOF

$grpc tasklet.api.v2.TaskletService/GetBuild <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "billy_eilish",
    "build_id": "${last_build}"
}
EOF

$grpc tasklet.api.v2.TaskletService/GetBuild <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "woody",
    "build_id": ""
}
EOF

#
# Labels
#

$grpc tasklet.api.v2.TaskletService/CreateLabel <<EOF
{
    "label": {
        "meta": {
            "name": "default",
            "tasklet": "json_to_yaml",
            "namespace": "woody"
        },
        "spec": {
            "build_id": "${last_build}"
        }
    }
}
EOF

$grpc tasklet.api.v2.TaskletService/GetLabel <<EOF
{
    "label": "default",
    "tasklet": "json_to_yaml",
    "namespace": "woody"
}
EOF

$grpc tasklet.api.v2.TaskletService/ListLabels <<EOF
{
    "tasklet": "json_to_yaml",
    "namespace": "woody"
}
EOF

$grpc tasklet.api.v2.TaskletService/UpdateLabel <<EOF
{
    "label": {
        "meta": {
            "name": "default",
            "tasklet": "json_to_yaml",
            "namespace": "woody"
        },
        "spec": {
            "revision": 0,
            "build_id": "${last_build}"
        }

    }
}
EOF
