#!/bin/bash -x
local_address="http://localhost:8080"
test_address="http://tasklet-test.in.yandex-team.ru"
address=${local_address}

do_post() {
    path=${1}
    shift
    if [ ${address} != ${local_address} ]; then
        curl -v -H "Authorization: OAuth $(cat ~/.sandbox/token)" -X POST "${address}/${path}" "${@}"
    else
        curl -v -X POST "${address}/${path}"  "${@}"
    fi
}

do_get() {
    path=${1}
    shift
    if [ ${address} != ${local_address} ]; then
        curl -v -H "Authorization: OAuth $(cat ~/.sandbox/token)" -X GET "${address}/${path}" "${@}"
    else
        curl -v -X GET "${address}/${path}"  "${@}"
    fi
}

do_put() {
    path=${1}
    shift
    if [ ${address} != ${local_address} ]; then
        curl -v -H "Authorization: OAuth $(cat ~/.sandbox/token)" -X PUT "${address}/${path}" "${@}"
    else
        curl -v -X PUT "${address}/${path}"  "${@}"
    fi
}


do_get v1/namespaces/foo | json_pp
do_post v1/namespaces -H "Content-Type: application/json" -d \
    '{"namespace": {"meta": {"name": "foo", "account_id": "abc:123"}}}' | json_pp
do_get v1/namespaces/foo | json_pp

do_post v1/namespaces -H "Content-Type: application/json" -d \
    '{"namespace": {"meta": {"name": "bar", "account_id": "abc:124"}}}' | json_pp

do_post v1/namespaces/foo/tasks -H "Content-Type: application/json" -d \
    '{
        "tasklet": {
            "meta": {"name": "foo_tasklet", "namespace": "foo", "account_id": "abc:124"},
            "spec": {"catalog": "/home/alximik", "default_label": "l_default"}
        }
    }' | json_pp

do_post v1/namespaces/foo/tasks -H "Content-Type: application/json" -d \
    '
    {
        "tasklet": {
            "meta": {
                "name": "bar_tasklet",
                 "namespace": "foo",
                 "account_id": "abc:124"
            },
            "spec": {
                "catalog": "/home/alximik",
                 "revision": 3
            }
        }
    }
    ' | json_pp

do_get v1/namespaces/foo/tasks/foo_tasklet | json_pp
do_get v1/namespaces/foo/tasks/bar_tasklet | json_pp

do_put v1/namespaces/foo/tasks/bar_tasklet \
    -H "Content-Type: application/json" -d \
    '{
        "tasklet": {
            "meta": {
                "name": "bar_tasklet",
                 "namespace": "foo",
                 "account_id": "abc:124"
            },
            "spec": {
                "catalog": "/junk/alximik",
                "revision": 0
            }
        }
    }' | json_pp

# Create build

build="$(
    do_post v1/builds \
        -H "Content-Type: application/json" -d @- <<EOF | json_pp
{
    "build": {
        "meta": {
            "namespace": "foo",
            "tasklet": "bar_tasklet"
        },
        "spec": {
            "description": "build for bar_tasklet",
            "compute_resources": {
                "vcpu_limit": "1000",
                "memory_limit": "1000000000"
            }
        }
    }
}
EOF
)"

build_id="$(echo "${build}" | jq '.build.meta.id' | tr -d '"')"

# Get build
do_get v1/builds/"${build_id}" | json_pp

# List builds
do_get v1/namespaces/foo/tasks/bar_tasklet/builds?limit=100 | json_pp

#
# Labels
#

do_post v1/labels \
    -H "Content-Type: application/json" -d @- <<EOF
{
    "label": {
        "meta": {
            "name": "bar_latest_label",
            "namespace": "foo",
            "tasklet": "bar_tasklet"
        },
        "spec": {
            "build_id": "${build_id}"
        }
    }
}
EOF

# Get Label
do_get v1/namespaces/foo/tasks/bar_tasklet/labels/bar_latest_label | json_pp

# List Labels
do_get v1/namespaces/foo/tasks/bar_tasklet/labels | json_pp

# Update Label
do_put v1/namespaces/foo/tasks/bar_tasklet/labels/bar_latest_label \
    -H "Content-Type: application/json" -d @- <<EOF
{
    "label": {
        "meta": {},
        "spec": {
            "revision": 0,
            "build_id": "${build_id}"
        }

    }
}
EOF

# Execute

execution="$(
    do_post v1/namespaces/foo/tasks/bar_tasklet/labels/bar_latest_label/executions \
        -H "Content-Type: application/json" -d @- <<EOF
{}
EOF
)"

execution_id="$(echo "${execution}" | jq '.execution.meta.id' | tr -d '"')"
build_id="$(echo "${execution}" | jq '.execution.meta.build_id' | tr -d '"')"

do_get v1/executions/"${execution_id}" | json_pp


do_get v1/namespaces/foo/tasks/bar_tasklet/executions | json_pp

do_get v1/builds/"${build_id}"/executions'?token=300' | json_pp
