#!/bin/bash
set -x

get_arc_root() {
    local path="${1}"
    shift

    while [ "${path}" != "/" ]; do
        if [ -e "${path}/.arc/HEAD" ]; then
            break
        fi
        path="$( /usr/bin/dirname "${path}" )"
    done
    printf "%s" "${path}"
}

SCRIPT=$(readlink "${BASH_SOURCE[0]}")
SCRIPT_DIR="$( cd "$( dirname "${SCRIPT}" )" && pwd )"
arc_root=$(get_arc_root "${SCRIPT_DIR}")
if [ "${arc_root}" = "/" ]; then
    exit 1
fi

ya make \
    --add-result=.pb.go \
    --add-result=_pb2.py \
    --add-result=_pb2.pyi \
    --add-result=_pb2_grpc.py \
    --add-result=_pb2_grpc.pyi \
    --add-result=.pb.gw.go \
    --add-result=swagger.json \
    --add-result=.go \
    --replace-result \
    "${arc_root}/tasklet/api/v2" \
    "${arc_root}/tasklet/api/priv/v1" \
    "${arc_root}/tasklet/experimental/examples/proto" \
    "${arc_root}/tasklet/experimental/proto" \
    "${arc_root}/tasklet/tasklets/lifecycle/proto" \
    "${arc_root}/sandbox/tasklet/sidecars/resource_manager/proto"


ya make --add-result=.go  --replace-result "${arc_root}/sandbox/common/go/"

ya make --add-result=.pb.go --replace-result \
    "${arc_root}/library/go/test/grpctest" \
    "${arc_root}/yt/go/proto/client/api/rpc_proxy" \
    "${arc_root}/infra/yp_service_discovery/api" \
    "${arc_root}/yt/go/proto/core/tracing" \
    "${arc_root}/yt/go/proto/core/rpc"

ya make --add-result=_pb2.py --add-result=_pb2.pyi --replace-result "${arc_root}/contrib/libs/protobuf"
