package dummy

import (
	"io"
	"os"

	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/tasklet/api/v2"
)

const (
	TaskletContextEnvVar = "TASKLET_CONTEXT"
)

func GetContext() (*taskletv2.Context, error) {
	path := os.Getenv(TaskletContextEnvVar)
	contextFile, err := os.Open(path)
	if err != nil {
		return nil, err
	}
	data, err := io.ReadAll(contextFile)
	if err != nil {
		return nil, err
	}

	context := taskletv2.Context{}
	if err = proto.Unmarshal(data, &context); err != nil {
		return nil, err
	}

	return &context, nil
}

func MustGetContext() *taskletv2.Context {
	if context, err := GetContext(); err != nil {
		panic(err)
	} else {
		return context
	}
}

func GetExecutorServiceClient(address string) (taskletv2.ExecutorServiceClient, error) {
	if address == "" {
		return nil, xerrors.NewSentinel("executor service address is not provided")
	}

	options := []grpc.DialOption{
		grpc.WithTransportCredentials(insecure.NewCredentials()),
		grpc.WithUserAgent("tasklet"),
		grpc.WithBlock(),
	}
	conn, err := grpc.Dial(address, options...)
	if err != nil {
		return nil, err
	}
	return taskletv2.NewExecutorServiceClient(conn), nil
}

func MustGetExecutorServiceClient(address string) taskletv2.ExecutorServiceClient {
	if client, err := GetExecutorServiceClient(address); err != nil {
		panic(err)
	} else {
		return client
	}
}
