package dummy

import (
	"io/ioutil"

	"google.golang.org/protobuf/proto"
)

func ReadInput(message proto.Message, filePath string) error {
	data, err := ioutil.ReadFile(filePath)
	if err != nil {
		return err
	}
	return proto.Unmarshal(data, message)
}

func WriteOutput(message proto.Message, filePath string) error {
	data, err := proto.Marshal(message)
	if err != nil {
		return err
	}
	return ioutil.WriteFile(filePath, data, 0644)
}
