#pragma once

#include <tasklet/api/tasklet.pb.h>

#include <google/protobuf/descriptor.h>

namespace NTaskletGen {

using namespace google::protobuf;

class TTaskletComponents {
public:
    const Descriptor* D;
    const FieldDescriptor* InputField;
    const FieldDescriptor* OutputField;
    const FieldDescriptor* ContextField;
    const FieldDescriptor* RequirementsField;

    explicit TTaskletComponents(const Descriptor* descriptor);

    static bool IsTasklet(const Descriptor* descriptor) {
        return descriptor->options().HasExtension(tasklet::tasklet_interface);
    }

    static bool IsInput(const FieldDescriptor* field) {
        return field->options().HasExtension(tasklet::input);
    }

    static bool IsOutput(const FieldDescriptor* field) {
        return field->options().HasExtension(tasklet::output);
    }

    static bool IsContext(const Descriptor* descriptor) {
        return descriptor->options().HasExtension(tasklet::context);
    }

    static bool IsRequirements(const Descriptor* descriptor) {
        return descriptor->full_name() == tasklet::Requirements::descriptor()->full_name();
    }

    static bool IsService(const Descriptor* descriptor) {
        return descriptor->options().HasExtension(tasklet::service);
    }

    static bool ServiceHasRef(const Descriptor* descriptor) {
        for (int i = 0; i < descriptor->field_count(); i++) {
            auto field = descriptor->field(i);
            // TODO: Check if `ref` is something else?
            if (field->name() == "ref") {
                return true;
            }
        }
        return false;
    }

    static TProtoStringType GetService(const Descriptor* descriptor) {
        return descriptor->options().GetExtension(tasklet::service);
    }

};

} // namespace NTaskletGen
