#include "components.h"

namespace NTaskletGen {

TTaskletComponents::TTaskletComponents(const Descriptor* descriptor)
    : D(descriptor)
    , InputField(nullptr)
    , OutputField(nullptr)
    , ContextField(nullptr)
    , RequirementsField(nullptr)
{
    for (int i = 0; i < descriptor->field_count(); i++) {
        const FieldDescriptor* field = descriptor->field(i);
        if (IsInput(field)) {
            InputField = field;
        } else if (IsOutput(field)) {
            OutputField = field;
        } else if (IsContext(field->message_type())) {
            ContextField = field;
        } else if (IsRequirements(field->message_type())) {
            RequirementsField = field;
        }
    }

    Y_ASSERT(InputField != nullptr);
    Y_ASSERT(OutputField != nullptr);
    Y_ASSERT(ContextField != nullptr);
    Y_ASSERT(RequirementsField != nullptr);
}

} // namespace NTaskletGen
