#include "names.h"

#include <google/protobuf/compiler/code_generator.h>
#include <google/protobuf/compiler/cpp/cpp_helpers.h>
#include <google/protobuf/descriptor.h>
#include <google/protobuf/stubs/strutil.h>

namespace NTaskletGen {

using namespace google::protobuf;
using namespace google::protobuf::compiler;

// common

TProtoStringType BaseTaskletClassName(const Descriptor *descriptor) {
    return descriptor->name() + "Base";
}

// cpp

TProtoStringType ProtobufHeader(const FileDescriptor* file) {
    return cpp::StripProto(file->name()) + ".pb.h";
}

TProtoStringType TaskletHeader(const FileDescriptor* file) {
    return cpp::StripProto(file->name()) + ".tasklet.h";
}

// python

TProtoStringType TaskletFileName(const FileDescriptor* file) {
    return cpp::StripProto(file->name()) + "_tasklet.py";
}

TProtoStringType SandboxTaskFileName(const FileDescriptor* file) {
    return cpp::StripProto(file->name()) + "_sbtask.py";
}

// misc

TProtoStringType ProtoModuleName(const FileDescriptor* file) {
    TProtoStringType basename = cpp::StripProto(file->name());
    ReplaceCharacters(&basename, "/", '.');
    return basename + "_pb2";
}

TProtoStringType BaseTaskletModuleName(const FileDescriptor* file) {
    TProtoStringType basename = cpp::StripProto(file->name());
    ReplaceCharacters(&basename, "/", '.');
    return basename + "_tasklet";
}

TProtoStringType HolderClassName(const Descriptor *descriptor) {
    return descriptor->name();
}

TProtoStringType SandboxTaskClassName(const Descriptor *descriptor) {
    return "Tasklet" + descriptor->name();
}

TProtoStringType SandboxTaskModuleName(const Descriptor *descriptor) {
    TProtoStringType basename = cpp::StripProto(descriptor->file()->name());
    ReplaceCharacters(&basename, "/", '.');
    return basename + "_sbtask";
}

} // namespace NTaskletGen
