#pragma once

#include <google/protobuf/descriptor.h>

namespace NTaskletGen {

using namespace google::protobuf;

// common
TProtoStringType BaseTaskletClassName(const Descriptor *descriptor);

// cpp
TProtoStringType ProtobufHeader(const FileDescriptor* file);
TProtoStringType TaskletHeader(const FileDescriptor* file);

// python
TProtoStringType TaskletFileName(const FileDescriptor* file);
TProtoStringType SandboxTaskFileName(const FileDescriptor* file);

// misc

TProtoStringType ProtoModuleName(const FileDescriptor* file);
TProtoStringType BaseTaskletModuleName(const FileDescriptor *file);
TProtoStringType HolderClassName(const Descriptor *descriptor);
TProtoStringType SandboxTaskClassName(const Descriptor *descriptor);
TProtoStringType SandboxTaskModuleName(const Descriptor *descriptor);

} // namespace NTaskletGen
