#pragma once

#include <google/protobuf/compiler/code_generator.h>
#include <google/protobuf/io/printer.h>
#include <google/protobuf/descriptor.h>

namespace NTaskletGen {

using namespace google::protobuf;
using namespace google::protobuf::compiler;

class TPythonGenerator : public CodeGenerator {
public:
    TPythonGenerator();
    ~TPythonGenerator() override;

    bool Generate(
        const FileDescriptor* file,
        const TProtoStringType& parameter,
        GeneratorContext* generator_context,
        TProtoStringType* error
    ) const override;

    uint64_t GetSupportedFeatures() const override {
        return FEATURE_PROTO3_OPTIONAL;
    }

private:
    void GenerateImports(io::Printer& printer, const FileDescriptor* file) const;
    void GenerateHolder(io::Printer& printer, const Descriptor* descriptor) const;
    void GenerateBase(io::Printer& printer, const Descriptor* descriptor) const;

    void GenerateTaskletCode(io::Printer& printer, const FileDescriptor* file) const;
};

} // namespace NTaskletGen
