#pragma once

#include <tasklet/api/tasklet.pb.h>

namespace NTasklet {

template <class TaskletMessage, class InputMessage, class OutputMessage>
class ITasklet {
public:
    using TTaskletMessage = TaskletMessage;
    using TInputMessage = InputMessage;
    using TOutputMessage = OutputMessage;

    TString TaskletId;

    ITasklet() : TaskletId("") {};
    virtual ~ITasklet() = default;

    virtual void Run(const TInputMessage& input, TOutputMessage& output) = 0;

    virtual void SetupRequirements(const TInputMessage& input, tasklet::Requirements& requirements) {
        Y_UNUSED(input, requirements);
    };

    virtual void SetupDefaultInput(TInputMessage& input) {
        Y_UNUSED(input);
    };
};

}

