from util.generic.string cimport TString

import six

from tasklet.api import tasklet_pb2
from tasklet.runtime import utils


cdef extern from "tasklet/runtime/lib/dispatch.h" namespace "NTasklet":
    TString ImplClassPath(const TString& taskletName) except +

cdef extern from "tasklet/runtime/lib/dispatch.h" namespace "NTasklet":
    TString TaskletToImplName(const TString& taskletName) except +

cdef extern from "tasklet/runtime/lib/dispatch.h" namespace "NTasklet":
    TString Initialize() except +

cdef extern from "tasklet/runtime/lib/dispatch.h" namespace "NTasklet":
    TString Execute(const TString& data) except +

cdef extern from "tasklet/runtime/lib/dispatch.h" namespace "NTasklet":
    TString GetInitDescription(const TString& data) except +

cdef extern from "tasklet/runtime/lib/dispatch.h" namespace "NTasklet":
    TString ListTaskletNames() except +

cdef TString _to_TString(s):
    assert isinstance(s, (six.text_type, six.binary_type)), "Error: {} instead of string type".format(type(s))
    s = six.ensure_binary(s)
    return TString(<const char*>s, len(s))


def impl_class_path(tasklet_name):
    return six.ensure_text(ImplClassPath(_to_TString(tasklet_name)))


def name_to_impl(tasklet_name):
    s = six.ensure_text(TaskletToImplName(_to_TString(tasklet_name)))
    if not s:
        return None
    return s.split(";")


def list_tasklet_names():
    s = six.ensure_text(ListTaskletNames())
    return s and s.split(";")


def initialize_tasklet_registry():
    Initialize()


def dispatch(request):
    request = _to_TString(request.SerializeToString() if isinstance(request, tasklet_pb2.JobInstance) else request)
    return Execute(request)


def get_init_description(request):
    return GetInitDescription(
        _to_TString(request.SerializeToString() if isinstance(request, tasklet_pb2.JobStatement) else request)
    )


def get_holder(tasklet_name):
    impl_cls_path = impl_class_path(tasklet_name)
    return utils.import_symbol(impl_cls_path).__holder_cls__
